<!----------------------------------Login------------------------------------>
<?php

include 'php/db_connection.php';

// শুধুমাত্র লগইন করা ইউজার পেজ দেখতে পারবে
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$userName = $_SESSION['user_name'];
$role = $_SESSION['role']; // ✅ এখানে role সেভ করা হচ্ছে
$userId = $_SESSION['user_id'];


$isAdmin = ($_SESSION['role'] == 'admin');

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Custom Dashboard</title>
     <!-- <head> Due pageএর মধ্যে -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!--Due Page </body> এর আগে -->
     <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Bootstrap CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <!-- Include Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
    <!-- Custom CSS -->
   
    <style>
        /* Sidebar styling */
        .sidebar {
            background-color: #343a40;
            color: #ffffff;
            min-height: 100vh;
            position: fixed;
            width: 250px;
            padding-top: 20px;
            padding-bottom: 0;
            transition: transform 0.3s ease;
            z-index: 1000;
            overflow-y: auto;
            display: flex;
            flex-direction: column;
        }
        
        .sidebar.closed {
            transform: translateX(-100%);
        }
        
        .sidebar .logo {
            font-size: 1.5rem;
            font-weight: bold;
            color: #ffffff;
            text-align: center;
            padding-bottom: 20px;
            flex-shrink: 0;
        }
        .sidebar .nav-link {
            color: #adb5bd;
            padding: 10px 20px;
            display: block;
            font-size: 1rem;
        }
        .sidebar .nav-link.active, .sidebar .nav-link:hover {
            color: #ffffff;
            background-color: #495057;
        }
        
        /* Submenu styling */
        .submenu {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.3s ease;
            background-color: #2c3136;
        }
        
        .submenu.expanded {
            max-height: 500px;
        }
        
        .submenu-link {
            padding-left: 50px !important;
            font-size: 0.9rem;
        }
        
        .submenu-arrow {
            transition: transform 0.3s ease;
            font-size: 0.8rem;
        }
        
        .submenu-arrow.rotated {
            transform: rotate(180deg);
        }
        
        /* Sidebar Footer */
        .sidebar-footer {
            margin-top: auto;
            padding: 15px;
            background-color: #2c3136;
            border-top: 1px solid #495057;
            flex-shrink: 0;
        }
        
        .user-info-card {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 10px;
            background-color: #3a4046;
            border-radius: 8px;
            margin-bottom: 10px;
        }
        
        .user-avatar-circle {
            width: 45px;
            height: 45px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            font-size: 18px;
            color: white;
            flex-shrink: 0;
        }
        
        .user-details {
            flex: 1;
            overflow: hidden;
        }
        
        .user-name {
            font-weight: 600;
            font-size: 14px;
            color: #ffffff;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        
        .user-role {
            font-size: 12px;
            color: #adb5bd;
        }
        
        .footer-text {
            text-align: center;
            color: #6c757d;
        }
        
        .nav.flex-column {
            flex: 1;
            overflow-y: auto;
        }
        
        /* Dashboard content styling */
        .dashboard-content {
            margin-left: 250px;
            padding: 20px;
            background-color: #f8f9fa;
            min-height: 100vh;
            transition: margin-left 0.3s ease;
        }
        
        .dashboard-content.expanded {
            margin-left: 0;
        }
        
        .dashboard-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px 20px;
            background-color: #6c757d;
            color: #ffffff;
            border-radius: 0 0 10px 10px;
        }
        
        /* Box styling */
        .boxes .box {
            background-color: #ffffff;
            border-radius: 5px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            padding: 20px;
            text-align: center;
        }
        .boxes .box i {
            font-size: 2rem;
            color: #6c757d;
            margin-bottom: 10px;
        }
        .boxes .box .number {
            font-size: 1.5rem;
            font-weight: bold;
            color: #333333;
        }
        
        /* Mobile Toggle Button */
        .mobile-toggle {
            display: none;
            position: fixed;
            top: 15px;
            left: 15px;
            z-index: 1001;
            background: #343a40;
            border: none;
            color: white;
            width: 45px;
            height: 45px;
            border-radius: 8px;
            cursor: pointer;
            box-shadow: 0 4px 12px rgba(0,0,0,0.3);
            font-size: 20px;
        }
        
        /* Overlay for mobile */
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.5);
            z-index: 999;
        }
        
        .sidebar-overlay.active {
            display: block;
        }
        
        /* Topbar styling */
        .profile-img {
            width: 32px;
            height: 32px;
            border-radius: 50%;
            object-fit: cover;
        }
        .topbar {
            background-color: #f8fafc;
            padding: 10px 20px;
        }
        .search-box {
            max-width: 250px;
        }
        .icon-btn {
            background: none;
            border: none;
            margin-left: 10px;
        }
        .username {
            font-weight: bold;
        }
        .profile-section {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        /* Responsive adjustments */
        @media (max-width: 992px) {
            .sidebar {
                width: 250px;
                transform: translateX(-100%);
            }
            
            .sidebar.active {
                transform: translateX(0);
            }
            
            .dashboard-content {
                margin-left: 0;
            }
            
            .mobile-toggle {
                display: flex;
                align-items: center;
                justify-content: center;
            }
            
            .topbar {
                padding-left: 70px;
            }
        }
        
        @media (max-width: 576px) {
            .search-box {
                max-width: 150px;
            }
            
            .profile-section {
                gap: 5px;
            }
            
            .username {
                font-size: 14px;
            }
        }
        
        /* Scrollbar for sidebar */
        .sidebar::-webkit-scrollbar {
            width: 6px;
        }
        
        .sidebar::-webkit-scrollbar-track {
            background: #2c3136;
        }
        
        .sidebar::-webkit-scrollbar-thumb {
            background: #495057;
            border-radius: 3px;
        }
    </style>
</head>
<body>
<!----------------------------------Login------------------------------------>
<?php
include 'php/db_connection.php';

// শুধুমাত্র লগইন করা ইউজার পেজ দেখতে পারবে
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$userName = $_SESSION['user_name'];
$role = $_SESSION['role']; // ✅ এখানে role সেভ করা হচ্ছে
$userId = $_SESSION['user_id'];


$isAdmin = ($_SESSION['role'] == 'admin');

?>

<!---------------------------------কন্টেন------------------------------------>

    <!-- Mobile Toggle Button -->
    <button class="mobile-toggle" onclick="toggleSidebar()">
        <i class="fas fa-bars"></i>
    </button>

    <!-- Sidebar Overlay -->
    <div class="sidebar-overlay" id="sidebarOverlay" onclick="toggleSidebar()"></div>
    
    <!-- Sidebar -->
    <div class="sidebar" id="sidebar">
        <div class="logo">
            <i class="fas fa-camera-retro"></i> Vai Vai Digital Studio
        </div>
        <nav class="nav flex-column">
            <a href="index.php" class="nav-link active"><i class="fas fa-home"></i> Dashboard</a>
            
            <!-- Products Dropdown -->
            <div class="nav-item">
                <a href="javascript:void(0)" class="nav-link" onclick="toggleSubmenu('products')">
                    <i class="fas fa-box"></i> Product
                    <i class="fas fa-chevron-down float-end submenu-arrow" id="products-arrow"></i>
                </a>
                <div class="submenu" id="products-submenu">
                    <a href="sail_product.php" class="nav-link submenu-link"><i class="fas fa-shopping-cart"></i> Pos Product</a>
                    <a href="add_new_scen.php" class="nav-link submenu-link"><i class="fas fa-plus-circle"></i> Add New Pos</a>
                    <a href="scan.php" class="nav-link submenu-link"><i class="fas fa-barcode"></i> Scan</a>
                    <a href="add_product_name.php" class="nav-link submenu-link"><i class="fas fa-plus"></i> Add Product</a>
                    <a href="products_expiration.php" class="nav-link submenu-link"><i class="fas fa-calendar-times"></i> Products Expiration</a>
                    <a href="stock_alerts.php" class="nav-link submenu-link"><i class="fas fa-exclamation-triangle"></i> Stock Alerts</a>
                </div>
            </div>
            
            <a href="Customer.php" class="nav-link"><i class="fas fa-users"></i> Customer</a>
            <a href="php/customar_due/due_collections_list.php" class="nav-link"><i class="fas fa-users"></i> Due</a>
            <a href="customer_search_summary.php" class="nav-link"><i class="fas fa-users"></i> Customer Summary</a>
            <a href="suppliers.php" class="nav-link"><i class="fas fa-user"></i> Suppliers</a>
            <a href="suppliers_bill.php" class="nav-link"><i class="fas fa-user"></i> Suppliers Bill</a>
            <a href="sales_all_data.php" class="nav-link"><i class="fas fa-chart-line"></i> Sales All</a>
            <a href="sailes.php" class="nav-link"><i class="fas fa-chart-line"></i> Sailes</a>
            <a href="return_page.php" class="nav-link"><i class="fas fa-chart-line"></i> Return</a>
            <a href="fetch_invoice_products.php" class="nav-link"><i class="fas fa-chart-line"></i> Return Products</a>
            <a href="daily_report.php?days=30" class="nav-link"><i class="fas fa-chart-line"></i> Day Report</a>
            <a href="monthly_report.php" class="nav-link"><i class="fas fa-chart-line"></i> Monthly Report</a>
            <a href="cost_detelis.php" class="nav-link"><i class="fas fa-wallet"></i> Cost Management</a>
            <a href="manage_users.php" class="nav-link"><i class="fas fa-user"></i> User</a>
        </nav>
        
        <!-- Sidebar Footer -->
        <div class="sidebar-footer">
            <div class="user-info-card">
                <div class="user-avatar-circle">
                    <?php echo strtoupper(substr($userName, 0, 1)); ?>
                </div>
                <div class="user-details">
                    <div class="user-name"><?php echo htmlspecialchars($userName); ?></div>
                    <div class="user-role"><?php echo ucfirst($role); ?></div>
                </div>
            </div>
            <div class="footer-text">
                <small>&copy; 2025 Vai Vai Digital</small>
            </div>
        </div>
    </div>
    
    <!-- Main Dashboard Content -->
    <div class="dashboard-content" id="dashboardContent">
        <div class="dashboard-header1">
            
        </div><!-----এই ডিভ কাটা যাবে না-------------------------------->
    
    <!-----------------------------------------ইউজারের প্রফাল কোড------------------------------------- -->
    <div class="topbar d-flex justify-content-between align-items-center">
        <!-- Search -->
        <div class="search-box input-group">
            <input type="text" class="form-control" placeholder="Search">
            <button class="btn btn-outline-secondary" type="button">
                <i class="bi bi-search"></i>
            </button>
        </div>

        
        <div class="d-flex align-items-center">
            <!-- Profile Section -->
            <div class="profile-section ms-3">
                <div>
                    <div class="username"><strong><?php echo htmlspecialchars($userName); ?></strong></div>
                    <small class="text-muted"><?php echo ucfirst($role); ?></small>
                </div>
                <img src="https://www.svgrepo.com/show/384674/account-avatar-profile-user-11.svg" class="profile-img" alt="Profile">
            </div>

            <!-- লগআউট আইকন -->
            <a href="logout.php" title="Logout">
                <button class="icon">
                    <i class="bi bi-power"></i>
                </button>
            </a>
        </div>
    </div>
    <hr class="my-3">
    
    <!-------------------------------------------উপরে ইউজারের প্রফাইল কোড----------------------------->
    
    <!-- Optional JavaScript -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    
    <script>
        function toggleSidebar() {
            var sidebar = document.getElementById('sidebar');
            var overlay = document.getElementById('sidebarOverlay');
            
            sidebar.classList.toggle('active');
            overlay.classList.toggle('active');
        }
        
        function toggleSubmenu(menuId) {
            var submenu = document.getElementById(menuId + '-submenu');
            var arrow = document.getElementById(menuId + '-arrow');
            
            submenu.classList.toggle('expanded');
            arrow.classList.toggle('rotated');
        }
        
        // Close sidebar when clicking on a link (mobile only)
        document.querySelectorAll('.sidebar .nav-link').forEach(function(link) {
            link.addEventListener('click', function(e) {
                // Don't close if it's a submenu toggle
                if (this.getAttribute('onclick') && this.getAttribute('onclick').includes('toggleSubmenu')) {
                    return;
                }
                
                if (window.innerWidth <= 992) {
                    toggleSidebar();
                }
            });
        });
        
        // Handle window resize
        window.addEventListener('resize', function() {
            var sidebar = document.getElementById('sidebar');
            var overlay = document.getElementById('sidebarOverlay');
            
            if (window.innerWidth > 992) {
                sidebar.classList.remove('active');
                overlay.classList.remove('active');
            }
        });
    </script>
</body>
</html>