<?php
include 'php/db_connection.php';
session_start();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Return Process</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css">
</head>
<body class="p-4">
<?php include 'sidebar.php'; ?>
<h3>Return Product</h3>

<!-- Search Invoice -->
<form method="get" class="form-inline mb-3">
    <input type="text" name="invoice_id" class="form-control mr-2" placeholder="Enter Invoice ID" required>
    <button type="submit" class="btn btn-primary">Search</button>
</form>

<?php
if (isset($_GET['invoice_id'])) {
    $invoice_id = intval($_GET['invoice_id']);

    // Fetch products for this invoice
    $invoice_items = $con->query("
        SELECT si.id, si.product_id, p.name, si.quantity, si.price, si.purchase_price 
        FROM sales_items si 
        JOIN product p ON si.product_id=p.Product_id
        WHERE si.sales_id='$invoice_id'
    ");

    if ($invoice_items->num_rows > 0) {
        echo "<form method='post'>";
        echo "<input type='hidden' name='invoice_id' value='$invoice_id'>";
        echo "<table class='table table-bordered'>
                <tr>
                    <th>Product</th>
                    <th>Sold Qty</th>
                    <th>Return Qty</th>
                    <th>Reason</th>
                    <th>Notes</th>
                </tr>";
        while ($row = $invoice_items->fetch_assoc()) {
            echo "<tr>
                    <td>{$row['name']}</td>
                    <td>{$row['quantity']}</td>
                    <td><input type='number' name='return_qty[{$row['product_id']}]' max='{$row['quantity']}' min='0' class='form-control'></td>
                    <td><input type='text' name='reason[{$row['product_id']}]' class='form-control'></td>
                    <td><input type='text' name='notes[{$row['product_id']}]' class='form-control'></td>
                  </tr>
                  <input type='hidden' name='price[{$row['product_id']}]' value='{$row['price']}'>
                  <input type='hidden' name='purchase_price[{$row['product_id']}]' value='{$row['purchase_price']}'>
                  <input type='hidden' name='sold_qty[{$row['product_id']}]' value='{$row['quantity']}'>";
        }
        echo "</table>
              <button type='submit' name='process_return' class='btn btn-success'>Submit Return</button>
              </form>";
    } else {
        echo "<div class='alert alert-danger'>No products found for this Invoice.</div>";
    }
}
?>

<?php
if (isset($_POST['process_return'])) {
    $invoice_id = $_POST['invoice_id'];
    $customer_id = 1; // session থেকে লাগলে ব্যবহার করুন
    $total_refund = 0;

    foreach ($_POST['return_qty'] as $product_id => $qty) {
        if ($qty > 0) {
            $reason = $_POST['reason'][$product_id];
            $notes = $_POST['notes'][$product_id];
            $price = $_POST['price'][$product_id];
            $purchase_price = $_POST['purchase_price'][$product_id];

            $refund_amount = $qty * $price;
            $total_refund += $refund_amount;

            // 1️⃣ Insert into return_items
            $stmt = $con->prepare("
                INSERT INTO return_items (invoice_id, customer_id, product_id, return_quantity, reason, notes, refund_amount, status)
                VALUES (?, ?, ?, ?, ?, ?, ?, 'completed')
            ");
            $stmt->bind_param("iiiissd", $invoice_id, $customer_id, $product_id, $qty, $reason, $notes, $refund_amount);
            $stmt->execute();

            // 2️⃣ Update product stock
            $con->query("UPDATE product SET Quantity = Quantity + $qty WHERE Product_id = $product_id");

            // 3️⃣ Update sales_items quantity
            $con->query("UPDATE sales_items 
                         SET quantity = quantity - $qty
                         WHERE sales_id = $invoice_id AND product_id = $product_id");

            // 4️⃣ If quantity = 0, update price/purchase/total
            $con->query("UPDATE sales_items 
                         SET price = CASE WHEN quantity = 0 THEN 0 ELSE price END,
                             purchase_price = CASE WHEN quantity = 0 THEN 0 ELSE purchase_price END,
                             total = CASE WHEN quantity = 0 THEN 0 ELSE quantity * price END,
                             total_purchase = CASE WHEN quantity = 0 THEN 0 ELSE quantity * purchase_price END
                         WHERE sales_id = $invoice_id AND product_id = $product_id");
        }
    }

    // 5️⃣ Update sales totals
    $result = $con->query("SELECT SUM(quantity * price) as new_grand_total, SUM(quantity * price) as new_final_amount
                           FROM sales_items 
                           WHERE sales_id = $invoice_id");
    $row = $result->fetch_assoc();
    $new_grand_total = $row['new_grand_total'] ?? 0;
    $new_final_amount = $row['new_final_amount'] ?? 0;

    // Fetch collected_one for final_due
    $sale_result = $con->query("SELECT collected_one FROM sales WHERE id = $invoice_id");
    $sale_row = $sale_result->fetch_assoc();
    $collected_one = $sale_row['collected_one'] ?? 0;

    // 💡 final_due can be negative now
    $new_final_due = $new_final_amount - $collected_one;

    // Update sales table
    $con->query("UPDATE sales 
                 SET grand_total = $new_grand_total,
                     final_amount = $new_final_amount,
                     final_due = $new_final_due
                 WHERE id = $invoice_id");

    echo "<div class='alert alert-success'>✅ Return processed successfully, invoice & stock updated!</div>";
}
?>

</body>
</html>
