<?php
session_start();
include 'php/db_connection.php';
require('pdf/fpdf.php'); // Use regular FPDF, NOT tFPDF
if(!isset($_SESSION['user_id'])){
    header("Location: login.php");
    exit();
}

date_default_timezone_set('Asia/Dhaka');
$year = date('Y');

// Fetch summary
$summary_result = $con->query("
    SELECT COUNT(id) as total_sales,
           SUM(grand_total) as grand_total,
           SUM(collected) as total_collected,
           SUM(final_due) as total_due
    FROM sales
    WHERE YEAR(created_at) = '$year'
");
$summary = $summary_result->fetch_assoc();

// Fetch monthly sales (only months with sales)
$result = $con->query("
    SELECT MONTH(created_at) as sale_month,
           COUNT(id) as total_sales,
           SUM(grand_total) as grand_total,
           SUM(collected) as total_collected,
           SUM(final_due) as total_due
    FROM sales
    WHERE YEAR(created_at) = '$year'
    GROUP BY MONTH(created_at)
    ORDER BY MONTH(created_at) ASC
");

// PDF class
class PDF extends FPDF {
    function Header(){
        $this->SetFont('Arial','B',14);
        $this->Cell(0,10,'Monthly Sales Report',0,1,'C');
        $this->SetFont('Arial','',10);
        $this->Cell(0,5,'Year: '.date('Y'),0,1,'C');
        $this->Ln(5);
    }

    function Footer(){
        $this->SetY(-15);
        $this->SetFont('Arial','I',8);
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }

    function SummaryTable($summary){
        $this->SetFont('Arial','B',12);
        $this->Cell(0,10,'Summary',0,1,'C');
        $this->SetFont('Arial','',10);
        
        $tableWidth = 200; // summary table width
        $startX = ($this->GetPageWidth() - $tableWidth)/2;
        $this->SetX($startX);

        $this->Cell(50,8,'Total Sales',1,0,'C');
        $this->Cell(50,8,'Grand Total',1,0,'C');
        $this->Cell(50,8,'Collected',1,0,'C');
        $this->Cell(50,8,'Due',1,1,'C');

        $this->SetX($startX);
        $this->Cell(50,8,$summary['total_sales'],1,0,'C');
        $this->Cell(50,8,number_format($summary['grand_total'],2),1,0,'C');
        $this->Cell(50,8,number_format($summary['total_collected'],2),1,0,'C');
        $this->Cell(50,8,number_format($summary['total_due'],2),1,1,'C');
        $this->Ln(10);
    }

    function MonthlyDetailHeader($tableWidth){
        $this->SetFont('Arial','B',10);
        $startX = ($this->GetPageWidth() - $tableWidth)/2;
        $this->SetX($startX);

        $this->Cell(40,8,'Month',1,0,'C');
        $this->Cell(40,8,'Total Sales',1,0,'C');
        $this->Cell(40,8,'Grand Total',1,0,'C');
        $this->Cell(40,8,'Collected',1,0,'C');
        $this->Cell(40,8,'Due',1,1,'C');
    }
}

// Initialize PDF
$pdf = new PDF('P','mm','A4');
$pdf->SetMargins(10,10,10);
$pdf->AliasNbPages();
$pdf->AddPage();

// Summary table (centered)
$pdf->SummaryTable($summary);

// Monthly details table (centered)
$tableWidth = 200;
$pdf->MonthlyDetailHeader($tableWidth);
$pdf->SetFont('Arial','',10);

while($row = $result->fetch_assoc()){
    $month_num = intval($row['sale_month']);
    $month_name = date('F', mktime(0,0,0,$month_num,10));
    
    $startX = ($pdf->GetPageWidth() - $tableWidth)/2;
    $pdf->SetX($startX);

    $pdf->Cell(40,8,$month_name,1,0,'C');
    $pdf->Cell(40,8,$row['total_sales'],1,0,'C');
    $pdf->Cell(40,8,number_format($row['grand_total'],2),1,0,'C');
    $pdf->Cell(40,8,number_format($row['total_collected'],2),1,0,'C');
    $pdf->Cell(40,8,number_format($row['total_due'],2),1,1,'C');
}

// Output PDF
$pdf->Output('I','monthly_sales_report.pdf');
