<!-- header.php -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Shop Management</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .container {
            max-width: 500px;
            margin-top: 50px;
        }
    </style>
</head>
<body>

<?php
session_start();
include 'php/db_connection.php';

// শুধুমাত্র লগইন করা ইউজার পেজ দেখতে পারবে
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$userName = $_SESSION['user_name'];
$role = $_SESSION['role']; // ✅ এখানে role সেভ করা হচ্ছে


$isAdmin = ($_SESSION['role'] == 'admin');




// ইউজার ডিলিট করার অনুমতি শুধু অ্যাডমিন পাবে
if ($isAdmin && isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $stmt = $con->prepare("DELETE FROM users_shop WHERE id = ?");
    $stmt->bind_param("i", $id);
    if ($stmt->execute()) {
        echo "<script>alert('ইউজার মুছে ফেলা হয়েছে!'); window.location='manage_users.php';</script>";
    }
}

// ইউজার লিস্ট দেখানো
$result = $con->query("SELECT * FROM users_shop");

?>
<?php include 'sidebar.php'; ?>
<div class="container mt-4">
    <h2 class="text-center">ইউজার পরিচালনা</h2>
    <?php if ($isAdmin): ?>
        <a href="add_user.php" class="btn btn-primary mb-3">নতুন ইউজার যোগ করুন</a>
    <?php else: ?>
        <p class="text-danger">শুধুমাত্র অ্যাডমিন নতুন ইউজার যোগ করতে পারে!</p>
    <?php endif; ?>
    
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>নাম</th>
                <th>ইমেইল</th>
                <th>ভূমিকা</th>
                <th>কার্যক্রম</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($row = $result->fetch_assoc()): ?>
                <tr>
                    <td><?= $row['id'] ?></td>
                    <td><?= $row['name'] ?></td>
                    <td><?= $row['email'] ?></td>
                    <td><?= ucfirst($row['role']) ?></td>
                    <td>
                        <?php if ($isAdmin): ?>
                            <a href="edit_user.php?id=<?= $row['id'] ?>" class="btn btn-warning btn-sm">এডিট</a>
                            <a href="?delete=<?= $row['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('আপনি কি নিশ্চিতভাবে মুছতে চান?')">ডিলিট</a>
                        <?php else: ?>
                            <span class="text-muted">No Permission</span>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>
</body>
</html>
