

<?php
include 'php/db_connection.php';

// শুধুমাত্র লগইন করা ইউজার পেজ দেখতে পারবে
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$userName = $_SESSION['user_name'];
$role = $_SESSION['role']; // ✅ এখানে role সেভ করা হচ্ছে
$userId = $_SESSION['user_id'];


$isAdmin = ($_SESSION['role'] == 'admin');

?>



<?php
require('pdf/fpdf.php');
require 'vendor-barcode/autoload.php'; // Barcode library autoload

use Picqer\Barcode\BarcodeGeneratorPNG;

// কানেকশন
$con->set_charset("utf8mb4");

$id = $_GET['id'] ?? 0;

// সেলস ইনফো
$sales = $con->query("SELECT * FROM sales WHERE id = $id")->fetch_assoc();
if (!$sales) die("Invalid Sales ID");

// কাস্টমার ইনফো
$customer = $con->query("SELECT * FROM customer WHERE id = {$sales['customer_id']}")->fetch_assoc();

// আইটেম
$items = $con->query("SELECT * FROM sales_items WHERE sales_id = $id");

// PDF শুরু — 100mm width for 4-inch printer
$pdf = new FPDF('P','mm',[100,150]);
$pdf->AddPage();
$pdf->SetMargins(5, 5, 5);


// 🔹 বারকোড যোগ করা (Invoice ID দিয়ে)
$generator = new BarcodeGeneratorPNG();
$barcodeData = $generator->getBarcode($sales['id'], $generator::TYPE_CODE_128);

// ইমেজ সেভ টেম্পোরারি ফাইল আকারে
$tempBarcode = tempnam(sys_get_temp_dir(), 'barcode') . '.png';
file_put_contents($tempBarcode, $barcodeData);

// ইমেজ PDF এ বসানো
$pdf->Image($tempBarcode, 30, $pdf->GetY()+5, 40, 12); 
$pdf->Ln(20);

// টেম্প ফাইল মুছে ফেলা
unlink($tempBarcode);

$pdf->SetFont('Arial','B',10);
$pdf->Cell(0,5,'SHOP NAME HERE',0,1,'C');
$pdf->SetFont('Arial','',9);
$pdf->Cell(0,5,'Address line here',0,1,'C');
$pdf->Cell(0,5,'Phone: 01XXXXXXXXX',0,1,'C');
$pdf->Ln(2);


$pdf->SetFont('Arial','',9);
$pdf->Cell(50,5,"Customer: " . $customer['Customer_name'],0,0);
$pdf->Cell(0,5,"Invoice: #" . $sales['id'],0,1);
$pdf->Cell(50,5,"Phone: " . $customer['Customer_phone'],0,0);
$pdf->Cell(0,5,"Date: " . date("d-m-Y h:i A", strtotime($sales['created_at'])),0,1);
$pdf->Cell(0,5,"Address: " . $customer['Customer_address'],0,1);
$pdf->Ln(2);


// হেডার
$pdf->SetFont('Arial','B',9);
$pdf->Cell(5,6,'#',1);
$pdf->Cell(40,6,'Product',1);
$pdf->Cell(10,6,'Qty',1,0,'C');
$pdf->Cell(18,6,'Price',1,0,'R');
$pdf->Cell(18,6,'Total',1,1,'R');


// আইটেম
$pdf->SetFont('Arial','',9);
$i = 1;
$grand_total = 0;
while ($item = $items->fetch_assoc()) {
    $pdf->Cell(5,6,$i++,1);
    $pdf->Cell(40,6,substr($item['product_description'],0,18),1);
    $pdf->Cell(10,6,$item['quantity'],1,0,'C');
    $pdf->Cell(18,6,number_format($item['price'],2),1,0,'R');
    $pdf->Cell(18,6,number_format($item['total'],2),1,1,'R');
    $grand_total += $item['total'];
}

// সারাংশ
$pdf->Ln(1);
$pdf->SetFont('Arial','',9);

function addSummaryRow($pdf, $label, $amount) {
    $pdf->Cell(70,5,$label,0,0,'R');
    $pdf->Cell(20,5,number_format($amount, 2),0,1,'R');
}

addSummaryRow($pdf, 'Sub Total:', $sales['grand_total']);
addSummaryRow($pdf, 'Discount:', $sales['discount']);
addSummaryRow($pdf, 'Collected:', $sales['collected_one']);
addSummaryRow($pdf, 'Due:', $sales['grand_total'] - $sales['collected']);
addSummaryRow($pdf, 'Change:', $sales['change']);

$pdf->Ln(4);
$pdf->SetFont('Arial','I',9);
$pdf->Cell(0,5,'Thank you for your purchase!',0,1,'C');

/* 🔹 বারকোড যোগ করা (Invoice ID দিয়ে)
$generator = new BarcodeGeneratorPNG();
$barcodeData = $generator->getBarcode($sales['id'], $generator::TYPE_CODE_128);

// ইমেজ সেভ টেম্পোরারি ফাইল আকারে
$tempBarcode = tempnam(sys_get_temp_dir(), 'barcode') . '.png';
file_put_contents($tempBarcode, $barcodeData);

// ইমেজ PDF এ বসানো
$pdf->Image($tempBarcode, 30, $pdf->GetY()+5, 40, 12); 
$pdf->Ln(20);

// টেম্প ফাইল মুছে ফেলা
unlink($tempBarcode); ---*/

$pdf->Output();
?>
