
<?php
include 'php/db_connection.php';

// শুধুমাত্র লগইন করা ইউজার পেজ দেখতে পারবে
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$userName = $_SESSION['user_name'];
$role = $_SESSION['role']; // ✅ এখানে role সেভ করা হচ্ছে
$userId = $_SESSION['user_id'];


$isAdmin = ($_SESSION['role'] == 'admin');

?>



<?php
// Create a completely fresh file - save this as customer_summary_new.php
require('pdf/fpdf.php'); // Use regular FPDF, NOT tFPDF
$con->set_charset("utf8mb4");

$customer_id = $_GET['customer_id'] ?? 0;

// Customer Information
$customer = $con->query("SELECT * FROM customer WHERE id = $customer_id")->fetch_assoc();
if (!$customer) die("Invalid Customer ID");

$total_sales = $con->query("SELECT SUM(grand_total) AS total_sales FROM sales WHERE customer_id = $customer_id")->fetch_assoc()['total_sales'] ?? 0;

$sales_collected = $con->query("SELECT SUM(collected) AS collected FROM sales WHERE customer_id = $customer_id")->fetch_assoc()['collected'] ?? 0;
$due_collected = $con->query("SELECT SUM(collected_amount) AS collected FROM due_collections WHERE customer_id = $customer_id")->fetch_assoc()['collected'] ?? 0;
$total_collected = $sales_collected + $due_collected;
$total_due = $total_sales - $total_collected;

// PDF setup - A4 size for detailed report
$pdf = new FPDF('P','mm','A4');
$pdf->AddPage();
$pdf->SetMargins(10, 10, 10);

// Header
$pdf->SetFont('Arial','B',16);
$pdf->Cell(0,10,'Vai Vai Digital Studio',0,1,'C');
$pdf->SetFont('Arial','',12);
$pdf->Cell(0,5,'Customer Summary Report',0,1,'C');
$pdf->Ln(5);

// Customer Info
$pdf->SetFont('Arial','B',12);
$pdf->Cell(0,8,'Customer Information',0,1);
$pdf->SetFont('Arial','',11);
$pdf->Cell(40,6,'Name:',0,0);
$pdf->Cell(0,6,$customer['Customer_name'],0,1);
$pdf->Cell(40,6,'Phone:',0,0);
$pdf->Cell(0,6,$customer['Customer_phone'],0,1);
$pdf->Cell(40,6,'Address:',0,0);
$pdf->Cell(0,6,$customer['Customer_address'],0,1);
$pdf->Ln(5);

// Summary Table
$pdf->SetFont('Arial','B',11);
$pdf->Cell(60,8,'Total Purchase',1,0,'C');
$pdf->Cell(60,8,'Total Collected',1,0,'C');
$pdf->Cell(60,8,'Total Due',1,1,'C');
$pdf->SetFont('Arial','',11);
$pdf->Cell(60,8,number_format($total_sales,2) . ' Tk',1,0,'C');
$pdf->Cell(60,8,number_format($total_collected,2) . ' Tk',1,0,'C');
$pdf->Cell(60,8,number_format($total_due,2) . ' Tk',1,1,'C');
$pdf->Ln(8);

// Purchase History
$pdf->SetFont('Arial','B',12);
$pdf->Cell(0,8,'Purchase History',0,1);
$pdf->SetFont('Arial','B',10);
$pdf->Cell(10,6,'#',1,0,'C');
$pdf->Cell(50,6,'Date',1,0,'C');
$pdf->Cell(40,6,'Invoice ID',1,0,'C');
$pdf->Cell(40,6,'Amount (Tk)',1,0,'C');
$pdf->Cell(40,6,'Collected (Tk)',1,1,'C');

$pdf->SetFont('Arial','',10);
$purchases = $con->query("SELECT id, created_at, grand_total, collected FROM sales WHERE customer_id = $customer_id ORDER BY created_at DESC");
$i = 1;
while ($row = $purchases->fetch_assoc()) {
    $pdf->Cell(10,6,$i++,1,0,'C');
    $pdf->Cell(50,6,date("d-m-Y", strtotime($row['created_at'])),1);
    $pdf->Cell(40,6,'#' . $row['id'],1,0,'C');
    $pdf->Cell(40,6,number_format($row['grand_total'],2),1,0,'R');
    $pdf->Cell(40,6,number_format($row['collected'],2),1,1,'R');
}
$pdf->Ln(8);

// Collection History
$pdf->SetFont('Arial','B',12);
$pdf->Cell(0,8,'Collection History',0,1);
$pdf->SetFont('Arial','B',10);
$pdf->Cell(10,6,'#',1,0,'C');
$pdf->Cell(50,6,'Date',1,0,'C');
$pdf->Cell(50,6,'Type',1,0,'C');
$pdf->Cell(40,6,'Amount (Tk)',1,1,'C');

$pdf->SetFont('Arial','',10);
$collection_num = 1;

// Collections from sales
$salesCollections = $con->query("SELECT created_at, collected FROM sales WHERE customer_id = $customer_id AND collected > 0 ORDER BY created_at DESC");
while ($row = $salesCollections->fetch_assoc()) {
    $pdf->Cell(10,6,$collection_num++,1,0,'C');
    $pdf->Cell(50,6,date("d-m-Y", strtotime($row['created_at'])),1);
    $pdf->Cell(50,6,'Sales Collection',1);
    $pdf->Cell(40,6,number_format($row['collected'],2),1,1,'R');
}

// Collections from due_collections
$dueCollections = $con->query("SELECT collected_at, collected_amount FROM due_collections WHERE customer_id = $customer_id ORDER BY collected_at DESC");
while ($row = $dueCollections->fetch_assoc()) {
    $pdf->Cell(10,6,$collection_num++,1,0,'C');
    $pdf->Cell(50,6,date("d-m-Y", strtotime($row['collected_at'])),1);
    $pdf->Cell(50,6,'Due Collection',1);
    $pdf->Cell(40,6,number_format($row['collected_amount'],2),1,1,'R');
}

$pdf->Ln(10);

// Footer
$pdf->SetFont('Arial','I',10);
$pdf->Cell(0,5,'Report Generated on: ' . date('d-m-Y h:i A'),0,1,'C');

$pdf->Output();
?>